package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsKmeansInitializationMethod(val value: String)
    extends Product
    with Serializable
object TrainingOptionsKmeansInitializationMethod {
  // Unspecified initialization method.
  case object KMEANS_INITIALIZATION_METHOD_UNSPECIFIED
      extends TrainingOptionsKmeansInitializationMethod("KMEANS_INITIALIZATION_METHOD_UNSPECIFIED")
  // Initializes the centroids randomly.
  case object RANDOM extends TrainingOptionsKmeansInitializationMethod("RANDOM")
  // Initializes the centroids using data specified in kmeans_initialization_column.
  case object CUSTOM extends TrainingOptionsKmeansInitializationMethod("CUSTOM")
  // Initializes with kmeans++.
  case object KMEANS_PLUS_PLUS extends TrainingOptionsKmeansInitializationMethod("KMEANS_PLUS_PLUS")
  val values = List(KMEANS_INITIALIZATION_METHOD_UNSPECIFIED, RANDOM, CUSTOM, KMEANS_PLUS_PLUS)
  def fromString(input: String): Either[String, TrainingOptionsKmeansInitializationMethod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsKmeansInitializationMethod")
  implicit val decoder: Decoder[TrainingOptionsKmeansInitializationMethod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsKmeansInitializationMethod] =
    Encoder[String].contramap(_.value)
}
