package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsHparamTuningObjective(val value: String)
    extends Product
    with Serializable
object TrainingOptionsHparamTuningObjective {
  // Unspecified evaluation metric.
  case object HPARAM_TUNING_OBJECTIVE_UNSPECIFIED
      extends TrainingOptionsHparamTuningObjective("HPARAM_TUNING_OBJECTIVE_UNSPECIFIED")
  // Mean absolute error. mean_absolute_error = AVG(ABS(label - predicted))
  case object MEAN_ABSOLUTE_ERROR
      extends TrainingOptionsHparamTuningObjective("MEAN_ABSOLUTE_ERROR")
  // Mean squared error. mean_squared_error = AVG(POW(label - predicted, 2))
  case object MEAN_SQUARED_ERROR extends TrainingOptionsHparamTuningObjective("MEAN_SQUARED_ERROR")
  // Mean squared log error. mean_squared_log_error = AVG(POW(LN(1 + label) - LN(1 + predicted), 2))
  case object MEAN_SQUARED_LOG_ERROR
      extends TrainingOptionsHparamTuningObjective("MEAN_SQUARED_LOG_ERROR")
  // Mean absolute error. median_absolute_error = APPROX_QUANTILES(absolute_error, 2)[OFFSET(1)]
  case object MEDIAN_ABSOLUTE_ERROR
      extends TrainingOptionsHparamTuningObjective("MEDIAN_ABSOLUTE_ERROR")
  // R^2 score. This corresponds to r2_score in ML.EVALUATE. r_squared = 1 - SUM(squared_error)/(COUNT(label)*VAR_POP(label))
  case object R_SQUARED extends TrainingOptionsHparamTuningObjective("R_SQUARED")
  // Explained variance. explained_variance = 1 - VAR_POP(label_error)/VAR_POP(label)
  case object EXPLAINED_VARIANCE extends TrainingOptionsHparamTuningObjective("EXPLAINED_VARIANCE")
  // Precision is the fraction of actual positive predictions that had positive actual labels. For multiclass this is a macro-averaged metric treating each class as a binary classifier.
  case object PRECISION extends TrainingOptionsHparamTuningObjective("PRECISION")
  // Recall is the fraction of actual positive labels that were given a positive prediction. For multiclass this is a macro-averaged metric.
  case object RECALL extends TrainingOptionsHparamTuningObjective("RECALL")
  // Accuracy is the fraction of predictions given the correct label. For multiclass this is a globally micro-averaged metric.
  case object ACCURACY extends TrainingOptionsHparamTuningObjective("ACCURACY")
  // The F1 score is an average of recall and precision. For multiclass this is a macro-averaged metric.
  case object F1_SCORE extends TrainingOptionsHparamTuningObjective("F1_SCORE")
  // Logorithmic Loss. For multiclass this is a macro-averaged metric.
  case object LOG_LOSS extends TrainingOptionsHparamTuningObjective("LOG_LOSS")
  // Area Under an ROC Curve. For multiclass this is a macro-averaged metric.
  case object ROC_AUC extends TrainingOptionsHparamTuningObjective("ROC_AUC")
  // Davies-Bouldin Index.
  case object DAVIES_BOULDIN_INDEX
      extends TrainingOptionsHparamTuningObjective("DAVIES_BOULDIN_INDEX")
  // Mean Average Precision.
  case object MEAN_AVERAGE_PRECISION
      extends TrainingOptionsHparamTuningObjective("MEAN_AVERAGE_PRECISION")
  // Normalized Discounted Cumulative Gain.
  case object NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN
      extends TrainingOptionsHparamTuningObjective("NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN")
  // Average Rank.
  case object AVERAGE_RANK extends TrainingOptionsHparamTuningObjective("AVERAGE_RANK")
  val values = List(
    HPARAM_TUNING_OBJECTIVE_UNSPECIFIED,
    MEAN_ABSOLUTE_ERROR,
    MEAN_SQUARED_ERROR,
    MEAN_SQUARED_LOG_ERROR,
    MEDIAN_ABSOLUTE_ERROR,
    R_SQUARED,
    EXPLAINED_VARIANCE,
    PRECISION,
    RECALL,
    ACCURACY,
    F1_SCORE,
    LOG_LOSS,
    ROC_AUC,
    DAVIES_BOULDIN_INDEX,
    MEAN_AVERAGE_PRECISION,
    NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN,
    AVERAGE_RANK,
  )
  def fromString(input: String): Either[String, TrainingOptionsHparamTuningObjective] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsHparamTuningObjective")
  implicit val decoder: Decoder[TrainingOptionsHparamTuningObjective] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsHparamTuningObjective] =
    Encoder[String].contramap(_.value)
}
