package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsHolidayRegion(val value: String)
    extends Product
    with Serializable
object TrainingOptionsHolidayRegion {
  // Holiday region unspecified.
  case object HOLIDAY_REGION_UNSPECIFIED
      extends TrainingOptionsHolidayRegion("HOLIDAY_REGION_UNSPECIFIED")
  // Global.
  case object GLOBAL extends TrainingOptionsHolidayRegion("GLOBAL")
  // North America.
  case object NA extends TrainingOptionsHolidayRegion("NA")
  // Japan and Asia Pacific: Korea, Greater China, India, Australia, and New Zealand.
  case object JAPAC extends TrainingOptionsHolidayRegion("JAPAC")
  // Europe, the Middle East and Africa.
  case object EMEA extends TrainingOptionsHolidayRegion("EMEA")
  // Latin America and the Caribbean.
  case object LAC extends TrainingOptionsHolidayRegion("LAC")
  // United Arab Emirates
  case object AE extends TrainingOptionsHolidayRegion("AE")
  // Argentina
  case object AR extends TrainingOptionsHolidayRegion("AR")
  // Austria
  case object AT extends TrainingOptionsHolidayRegion("AT")
  // Australia
  case object AU extends TrainingOptionsHolidayRegion("AU")
  // Belgium
  case object BE extends TrainingOptionsHolidayRegion("BE")
  // Brazil
  case object BR extends TrainingOptionsHolidayRegion("BR")
  // Canada
  case object CA extends TrainingOptionsHolidayRegion("CA")
  // Switzerland
  case object CH extends TrainingOptionsHolidayRegion("CH")
  // Chile
  case object CL extends TrainingOptionsHolidayRegion("CL")
  // China
  case object CN extends TrainingOptionsHolidayRegion("CN")
  // Colombia
  case object CO extends TrainingOptionsHolidayRegion("CO")
  // Czechoslovakia
  case object CS extends TrainingOptionsHolidayRegion("CS")
  // Czech Republic
  case object CZ extends TrainingOptionsHolidayRegion("CZ")
  // Germany
  case object DE extends TrainingOptionsHolidayRegion("DE")
  // Denmark
  case object DK extends TrainingOptionsHolidayRegion("DK")
  // Algeria
  case object DZ extends TrainingOptionsHolidayRegion("DZ")
  // Ecuador
  case object EC extends TrainingOptionsHolidayRegion("EC")
  // Estonia
  case object EE extends TrainingOptionsHolidayRegion("EE")
  // Egypt
  case object EG extends TrainingOptionsHolidayRegion("EG")
  // Spain
  case object ES extends TrainingOptionsHolidayRegion("ES")
  // Finland
  case object FI extends TrainingOptionsHolidayRegion("FI")
  // France
  case object FR extends TrainingOptionsHolidayRegion("FR")
  // Great Britain (United Kingdom)
  case object GB extends TrainingOptionsHolidayRegion("GB")
  // Greece
  case object GR extends TrainingOptionsHolidayRegion("GR")
  // Hong Kong
  case object HK extends TrainingOptionsHolidayRegion("HK")
  // Hungary
  case object HU extends TrainingOptionsHolidayRegion("HU")
  // Indonesia
  case object ID extends TrainingOptionsHolidayRegion("ID")
  // Ireland
  case object IE extends TrainingOptionsHolidayRegion("IE")
  // Israel
  case object IL extends TrainingOptionsHolidayRegion("IL")
  // India
  case object IN extends TrainingOptionsHolidayRegion("IN")
  // Iran
  case object IR extends TrainingOptionsHolidayRegion("IR")
  // Italy
  case object IT extends TrainingOptionsHolidayRegion("IT")
  // Japan
  case object JP extends TrainingOptionsHolidayRegion("JP")
  // Korea (South)
  case object KR extends TrainingOptionsHolidayRegion("KR")
  // Latvia
  case object LV extends TrainingOptionsHolidayRegion("LV")
  // Morocco
  case object MA extends TrainingOptionsHolidayRegion("MA")
  // Mexico
  case object MX extends TrainingOptionsHolidayRegion("MX")
  // Malaysia
  case object MY extends TrainingOptionsHolidayRegion("MY")
  // Nigeria
  case object NG extends TrainingOptionsHolidayRegion("NG")
  // Netherlands
  case object NL extends TrainingOptionsHolidayRegion("NL")
  // Norway
  case object NO extends TrainingOptionsHolidayRegion("NO")
  // New Zealand
  case object NZ extends TrainingOptionsHolidayRegion("NZ")
  // Peru
  case object PE extends TrainingOptionsHolidayRegion("PE")
  // Philippines
  case object PH extends TrainingOptionsHolidayRegion("PH")
  // Pakistan
  case object PK extends TrainingOptionsHolidayRegion("PK")
  // Poland
  case object PL extends TrainingOptionsHolidayRegion("PL")
  // Portugal
  case object PT extends TrainingOptionsHolidayRegion("PT")
  // Romania
  case object RO extends TrainingOptionsHolidayRegion("RO")
  // Serbia
  case object RS extends TrainingOptionsHolidayRegion("RS")
  // Russian Federation
  case object RU extends TrainingOptionsHolidayRegion("RU")
  // Saudi Arabia
  case object SA extends TrainingOptionsHolidayRegion("SA")
  // Sweden
  case object SE extends TrainingOptionsHolidayRegion("SE")
  // Singapore
  case object SG extends TrainingOptionsHolidayRegion("SG")
  // Slovenia
  case object SI extends TrainingOptionsHolidayRegion("SI")
  // Slovakia
  case object SK extends TrainingOptionsHolidayRegion("SK")
  // Thailand
  case object TH extends TrainingOptionsHolidayRegion("TH")
  // Turkey
  case object TR extends TrainingOptionsHolidayRegion("TR")
  // Taiwan
  case object TW extends TrainingOptionsHolidayRegion("TW")
  // Ukraine
  case object UA extends TrainingOptionsHolidayRegion("UA")
  // United States
  case object US extends TrainingOptionsHolidayRegion("US")
  // Venezuela
  case object VE extends TrainingOptionsHolidayRegion("VE")
  // Viet Nam
  case object VN extends TrainingOptionsHolidayRegion("VN")
  // South Africa
  case object ZA extends TrainingOptionsHolidayRegion("ZA")
  val values = List(
    HOLIDAY_REGION_UNSPECIFIED,
    GLOBAL,
    NA,
    JAPAC,
    EMEA,
    LAC,
    AE,
    AR,
    AT,
    AU,
    BE,
    BR,
    CA,
    CH,
    CL,
    CN,
    CO,
    CS,
    CZ,
    DE,
    DK,
    DZ,
    EC,
    EE,
    EG,
    ES,
    FI,
    FR,
    GB,
    GR,
    HK,
    HU,
    ID,
    IE,
    IL,
    IN,
    IR,
    IT,
    JP,
    KR,
    LV,
    MA,
    MX,
    MY,
    NG,
    NL,
    NO,
    NZ,
    PE,
    PH,
    PK,
    PL,
    PT,
    RO,
    RS,
    RU,
    SA,
    SE,
    SG,
    SI,
    SK,
    TH,
    TR,
    TW,
    UA,
    US,
    VE,
    VN,
    ZA,
  )
  def fromString(input: String): Either[String, TrainingOptionsHolidayRegion] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsHolidayRegion")
  implicit val decoder: Decoder[TrainingOptionsHolidayRegion] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsHolidayRegion] = Encoder[String].contramap(_.value)
}
