package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsFeedbackType(val value: String)
    extends Product
    with Serializable
object TrainingOptionsFeedbackType {
  // Default value.
  case object FEEDBACK_TYPE_UNSPECIFIED
      extends TrainingOptionsFeedbackType("FEEDBACK_TYPE_UNSPECIFIED")
  // Use weighted-als for implicit feedback problems.
  case object IMPLICIT extends TrainingOptionsFeedbackType("IMPLICIT")
  // Use nonweighted-als for explicit feedback problems.
  case object EXPLICIT extends TrainingOptionsFeedbackType("EXPLICIT")
  val values = List(FEEDBACK_TYPE_UNSPECIFIED, IMPLICIT, EXPLICIT)
  def fromString(input: String): Either[String, TrainingOptionsFeedbackType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsFeedbackType")
  implicit val decoder: Decoder[TrainingOptionsFeedbackType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsFeedbackType] = Encoder[String].contramap(_.value)
}
