package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsDistanceType(val value: String)
    extends Product
    with Serializable
object TrainingOptionsDistanceType {
  // Default value.
  case object DISTANCE_TYPE_UNSPECIFIED
      extends TrainingOptionsDistanceType("DISTANCE_TYPE_UNSPECIFIED")
  // Eculidean distance.
  case object EUCLIDEAN extends TrainingOptionsDistanceType("EUCLIDEAN")
  // Cosine distance.
  case object COSINE extends TrainingOptionsDistanceType("COSINE")
  val values = List(DISTANCE_TYPE_UNSPECIFIED, EUCLIDEAN, COSINE)
  def fromString(input: String): Either[String, TrainingOptionsDistanceType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsDistanceType")
  implicit val decoder: Decoder[TrainingOptionsDistanceType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsDistanceType] = Encoder[String].contramap(_.value)
}
