package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsDataSplitMethod(val value: String)
    extends Product
    with Serializable
object TrainingOptionsDataSplitMethod {
  // Default value.
  case object DATA_SPLIT_METHOD_UNSPECIFIED
      extends TrainingOptionsDataSplitMethod("DATA_SPLIT_METHOD_UNSPECIFIED")
  // Splits data randomly.
  case object RANDOM extends TrainingOptionsDataSplitMethod("RANDOM")
  // Splits data with the user provided tags.
  case object CUSTOM extends TrainingOptionsDataSplitMethod("CUSTOM")
  // Splits data sequentially.
  case object SEQUENTIAL extends TrainingOptionsDataSplitMethod("SEQUENTIAL")
  // Data split will be skipped.
  case object NO_SPLIT extends TrainingOptionsDataSplitMethod("NO_SPLIT")
  // Splits data automatically: Uses NO_SPLIT if the data size is small. Otherwise uses RANDOM.
  case object AUTO_SPLIT extends TrainingOptionsDataSplitMethod("AUTO_SPLIT")
  val values = List(DATA_SPLIT_METHOD_UNSPECIFIED, RANDOM, CUSTOM, SEQUENTIAL, NO_SPLIT, AUTO_SPLIT)
  def fromString(input: String): Either[String, TrainingOptionsDataSplitMethod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsDataSplitMethod")
  implicit val decoder: Decoder[TrainingOptionsDataSplitMethod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsDataSplitMethod] = Encoder[String].contramap(_.value)
}
