package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsDataFrequency(val value: String)
    extends Product
    with Serializable
object TrainingOptionsDataFrequency {
  // Default value.
  case object DATA_FREQUENCY_UNSPECIFIED
      extends TrainingOptionsDataFrequency("DATA_FREQUENCY_UNSPECIFIED")
  // Automatically inferred from timestamps.
  case object AUTO_FREQUENCY extends TrainingOptionsDataFrequency("AUTO_FREQUENCY")
  // Yearly data.
  case object YEARLY extends TrainingOptionsDataFrequency("YEARLY")
  // Quarterly data.
  case object QUARTERLY extends TrainingOptionsDataFrequency("QUARTERLY")
  // Monthly data.
  case object MONTHLY extends TrainingOptionsDataFrequency("MONTHLY")
  // Weekly data.
  case object WEEKLY extends TrainingOptionsDataFrequency("WEEKLY")
  // Daily data.
  case object DAILY extends TrainingOptionsDataFrequency("DAILY")
  // Hourly data.
  case object HOURLY extends TrainingOptionsDataFrequency("HOURLY")
  // Per-minute data.
  case object PER_MINUTE extends TrainingOptionsDataFrequency("PER_MINUTE")
  val values = List(
    DATA_FREQUENCY_UNSPECIFIED,
    AUTO_FREQUENCY,
    YEARLY,
    QUARTERLY,
    MONTHLY,
    WEEKLY,
    DAILY,
    HOURLY,
    PER_MINUTE,
  )
  def fromString(input: String): Either[String, TrainingOptionsDataFrequency] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsDataFrequency")
  implicit val decoder: Decoder[TrainingOptionsDataFrequency] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsDataFrequency] = Encoder[String].contramap(_.value)
}
