package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsDartNormalizeType(val value: String)
    extends Product
    with Serializable
object TrainingOptionsDartNormalizeType {
  // Unspecified dart normalize type.
  case object DART_NORMALIZE_TYPE_UNSPECIFIED
      extends TrainingOptionsDartNormalizeType("DART_NORMALIZE_TYPE_UNSPECIFIED")
  // New trees have the same weight of each of dropped trees.
  case object TREE extends TrainingOptionsDartNormalizeType("TREE")
  // New trees have the same weight of sum of dropped trees.
  case object FOREST extends TrainingOptionsDartNormalizeType("FOREST")
  val values = List(DART_NORMALIZE_TYPE_UNSPECIFIED, TREE, FOREST)
  def fromString(input: String): Either[String, TrainingOptionsDartNormalizeType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsDartNormalizeType")
  implicit val decoder: Decoder[TrainingOptionsDartNormalizeType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsDartNormalizeType] =
    Encoder[String].contramap(_.value)
}
