package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsColorSpace(val value: String) extends Product with Serializable
object TrainingOptionsColorSpace {
  // Unspecified color space
  case object COLOR_SPACE_UNSPECIFIED extends TrainingOptionsColorSpace("COLOR_SPACE_UNSPECIFIED")
  // RGB
  case object RGB extends TrainingOptionsColorSpace("RGB")
  // HSV
  case object HSV extends TrainingOptionsColorSpace("HSV")
  // YIQ
  case object YIQ extends TrainingOptionsColorSpace("YIQ")
  // YUV
  case object YUV extends TrainingOptionsColorSpace("YUV")
  // GRAYSCALE
  case object GRAYSCALE extends TrainingOptionsColorSpace("GRAYSCALE")
  val values = List(COLOR_SPACE_UNSPECIFIED, RGB, HSV, YIQ, YUV, GRAYSCALE)
  def fromString(input: String): Either[String, TrainingOptionsColorSpace] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsColorSpace")
  implicit val decoder: Decoder[TrainingOptionsColorSpace] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsColorSpace] = Encoder[String].contramap(_.value)
}
