package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsCategoryEncodingMethod(val value: String)
    extends Product
    with Serializable
object TrainingOptionsCategoryEncodingMethod {
  // Unspecified encoding method.
  case object ENCODING_METHOD_UNSPECIFIED
      extends TrainingOptionsCategoryEncodingMethod("ENCODING_METHOD_UNSPECIFIED")
  // Applies one-hot encoding.
  case object ONE_HOT_ENCODING extends TrainingOptionsCategoryEncodingMethod("ONE_HOT_ENCODING")
  // Applies label encoding.
  case object LABEL_ENCODING extends TrainingOptionsCategoryEncodingMethod("LABEL_ENCODING")
  // Applies dummy encoding.
  case object DUMMY_ENCODING extends TrainingOptionsCategoryEncodingMethod("DUMMY_ENCODING")
  val values = List(ENCODING_METHOD_UNSPECIFIED, ONE_HOT_ENCODING, LABEL_ENCODING, DUMMY_ENCODING)
  def fromString(input: String): Either[String, TrainingOptionsCategoryEncodingMethod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsCategoryEncodingMethod")
  implicit val decoder: Decoder[TrainingOptionsCategoryEncodingMethod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsCategoryEncodingMethod] =
    Encoder[String].contramap(_.value)
}
