package googleapis.bigquery

import io.circe._

sealed abstract class TrainingOptionsBoosterType(val value: String)
    extends Product
    with Serializable
object TrainingOptionsBoosterType {
  // Unspecified booster type.
  case object BOOSTER_TYPE_UNSPECIFIED
      extends TrainingOptionsBoosterType("BOOSTER_TYPE_UNSPECIFIED")
  // Gbtree booster.
  case object GBTREE extends TrainingOptionsBoosterType("GBTREE")
  // Dart booster.
  case object DART extends TrainingOptionsBoosterType("DART")
  val values = List(BOOSTER_TYPE_UNSPECIFIED, GBTREE, DART)
  def fromString(input: String): Either[String, TrainingOptionsBoosterType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for TrainingOptionsBoosterType")
  implicit val decoder: Decoder[TrainingOptionsBoosterType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[TrainingOptionsBoosterType] = Encoder[String].contramap(_.value)
}
