package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class TimePartitioning(
    // [Optional] Number of milliseconds for which to keep the storage for partitions in the table. The storage in a partition will have an expiration time of its partition time plus this value.
    expirationMs: Option[FiniteDuration] = None,
    // [Beta] [Optional] If not set, the table is partitioned by pseudo column, referenced via either '_PARTITIONTIME' as TIMESTAMP type, or '_PARTITIONDATE' as DATE type. If field is specified, the table is instead partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
    field: Option[String] = None,
    requirePartitionFilter: Option[Boolean] = None,
    // [Required] The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively. When the type is not specified, the default behavior is DAY.
    `type`: String,
)
object TimePartitioning {
  implicit val encoder: Encoder[TimePartitioning] = Encoder.instance { x =>
    Json.obj(
      "expirationMs" := x.expirationMs,
      "field" := x.field,
      "requirePartitionFilter" := x.requirePartitionFilter,
      "type" := x.`type`,
    )
  }
  implicit val decoder: Decoder[TimePartitioning] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[FiniteDuration]]("expirationMs")
      v1 <- c.get[Option[String]]("field")
      v2 <- c.get[Option[Boolean]]("requirePartitionFilter")
      v3 <- c.get[String]("type")
    } yield TimePartitioning(v0, v1, v2, v3)
  }
}
