package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TestIamPermissionsResponse(
    // A subset of `TestPermissionsRequest.permissions` that the caller is allowed.
    permissions: Option[List[String]] = None
)
object TestIamPermissionsResponse {
  implicit val encoder: Encoder[
    TestIamPermissionsResponse
  ] = Encoder.instance(x => Json.obj("permissions" := x.permissions))
  implicit val decoder: Decoder[
    TestIamPermissionsResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("permissions")
    } yield TestIamPermissionsResponse(v0)
  }
}
