package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TestIamPermissionsRequest(
    // The set of permissions to check for the `resource`. Permissions with wildcards (such as `*` or `storage.*`) are not allowed. For more information see [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
    permissions: Option[List[String]] = None
)
object TestIamPermissionsRequest {
  implicit val encoder: Encoder[
    TestIamPermissionsRequest
  ] = Encoder.instance(x => Json.obj("permissions" := x.permissions))
  implicit val decoder: Decoder[
    TestIamPermissionsRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("permissions")
    } yield TestIamPermissionsRequest(v0)
  }
}
