package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableSchema( // Describes the fields in a table.
    fields: Option[List[TableFieldSchema]] = None
)
object TableSchema {
  implicit val encoder: Encoder[TableSchema] = Encoder.instance { x =>
    Json.obj("fields" := x.fields)
  }
  implicit val decoder: Decoder[TableSchema] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[TableFieldSchema]]]("fields")
    } yield TableSchema(v0)
  }
}
