package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableRow(
    // Represents a single row in the result set, consisting of one or more fields.
    f: Option[List[TableCell]] = None
)
object TableRow {
  implicit val encoder: Encoder[TableRow] = Encoder.instance { x =>
    Json.obj("f" := x.f)
  }
  implicit val decoder: Decoder[TableRow] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[TableCell]]]("f")
    } yield TableRow(v0)
  }
}
