package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableReference(
    // [Required] The ID of the dataset containing this table.
    datasetId: String, // [Required] The ID of the project containing this table.
    projectId: String,
    // [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
    tableId: String,
)
object TableReference {
  implicit val encoder: Encoder[TableReference] = Encoder.instance { x =>
    Json.obj(
      "datasetId" := x.datasetId,
      "projectId" := x.projectId,
      "tableId" := x.tableId,
    )
  }
  implicit val decoder: Decoder[TableReference] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("datasetId")
      v1 <- c.get[String]("projectId")
      v2 <- c.get[String]("tableId")
    } yield TableReference(v0, v1, v2)
  }
}
