package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableListTableView(
    // True if view is defined in legacy SQL dialect, false if in standard SQL.
    useLegacySql: Option[Boolean] = None
)
object TableListTableView {
  implicit val encoder: Encoder[TableListTableView] = Encoder.instance { x =>
    Json.obj("useLegacySql" := x.useLegacySql)
  }
  implicit val decoder: Decoder[TableListTableView] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("useLegacySql")
    } yield TableListTableView(v0)

  }
}
