package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class TableListTable( // A reference uniquely identifying the table.
    tableReference: Option[TableReference] =
      None, // [Optional] The time when this table expires, in milliseconds since the epoch. If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
    expirationTime: Option[FiniteDuration] = None, // The user-friendly name for this table.
    friendlyName: Option[String] = None, // An opaque ID of the table
    id: Option[String] =
      None, // The time-based partitioning specification for this table, if configured.
    timePartitioning: Option[TimePartitioning] =
      None, // The labels associated with this table. You can use these to organize and group your tables.
    labels: Option[Map[String, String]] = None, // The resource type.
    kind: Option[String] = None, // The type of table. Possible values are: TABLE, VIEW.
    `type`: Option[String] =
      None, // The range partitioning specification for this table, if configured.
    rangePartitioning: Option[RangePartitioning] =
      None, // The time when this table was created, in milliseconds since the epoch.
    creationTime: Option[FiniteDuration] = None, // Additional details for a view.
    view: Option[TableListTableView] =
      None, // [Beta] Clustering specification for this table, if configured.
    clustering: Option[Clustering] = None,
)
object TableListTable {
  implicit val encoder: Encoder[TableListTable] = Encoder.instance { x =>
    Json.obj(
      "tableReference" := x.tableReference,
      "expirationTime" := x.expirationTime,
      "friendlyName" := x.friendlyName,
      "id" := x.id,
      "timePartitioning" := x.timePartitioning,
      "labels" := x.labels,
      "kind" :=
        x.kind,
      "type" := x.`type`,
      "rangePartitioning" := x.rangePartitioning,
      "creationTime" := x.creationTime,
      "view" := x.view,
      "clustering" := x.clustering,
    )
  }
  implicit val decoder: Decoder[TableListTable] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[TableReference]]("tableReference")
      v1 <- c.get[Option[FiniteDuration]]("expirationTime")
      v2 <- c.get[Option[String]]("friendlyName")
      v3 <- c.get[Option[String]]("id")
      v4 <- c.get[Option[TimePartitioning]]("timePartitioning")
      v5 <- c.get[Option[Map[String, String]]]("labels")
      v6 <- c.get[Option[String]]("kind")
      v7 <- c.get[Option[String]]("type")
      v8 <- c.get[Option[RangePartitioning]]("rangePartitioning")
      v9 <- c.get[Option[FiniteDuration]]("creationTime")
      v10 <- c.get[Option[TableListTableView]]("view")
      v11 <- c.get[Option[Clustering]]("clustering")
    } yield TableListTable(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11)
  }
}
