package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableList( // A hash of this page of results.
    etag: Option[String] = None, // A token to request the next page of results.
    nextPageToken: Option[String] = None, // The type of list.
    kind: Option[String] = None, // The total number of tables in the dataset.
    totalItems: Option[Int] = None, // Tables in the requested dataset.
    tables: Option[List[TableListTable]] = None,
)
object TableList {
  implicit val encoder: Encoder[TableList] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "nextPageToken" := x.nextPageToken,
      "kind" := x.kind,
      "totalItems" := x.totalItems,
      "tables" := x.tables,
    )
  }
  implicit val decoder: Decoder[TableList] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[String]]("nextPageToken")
      v2 <- c.get[Option[String]]("kind")
      v3 <- c.get[Option[Int]]("totalItems")
      v4 <- c.get[Option[List[TableListTable]]]("tables")
    } yield TableList(v0, v1, v2, v3, v4)
  }
}
