package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableFieldSchemaRangeElementType(
    // The field element type of a RANGE
    `type`: Option[String] = None
)
object TableFieldSchemaRangeElementType {
  implicit val encoder: Encoder[
    TableFieldSchemaRangeElementType
  ] = Encoder.instance(x => Json.obj("type" := x.`type`))
  implicit val decoder: Decoder[
    TableFieldSchemaRangeElementType
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("type")
    } yield TableFieldSchemaRangeElementType(v0)
  }
}
