package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableFieldSchemaPolicyTags(
    // A list of category resource names. For example, "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
    names: Option[List[String]] = None
)
object TableFieldSchemaPolicyTags {
  implicit val encoder: Encoder[
    TableFieldSchemaPolicyTags
  ] = Encoder.instance(x => Json.obj("names" := x.names))
  implicit val decoder: Decoder[
    TableFieldSchemaPolicyTags
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("names")
    } yield TableFieldSchemaPolicyTags(v0)
  }
}
