package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableFieldSchemaCategories(
    // A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most 5 categories are allowed.
    names: Option[List[String]] = None
)
object TableFieldSchemaCategories {
  implicit val encoder: Encoder[
    TableFieldSchemaCategories
  ] = Encoder.instance(x => Json.obj("names" := x.names))
  implicit val decoder: Decoder[
    TableFieldSchemaCategories
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("names")
    } yield TableFieldSchemaCategories(v0)
  }
}
