package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableFieldSchema(
    // [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and must start with a letter or underscore. The maximum length is 300 characters.
    name: String,
    // [Optional] Precision (maximum number of total digits in base 10) and scale (maximum number of digits in the fractional part in base 10) constraints for values of this field for NUMERIC or BIGNUMERIC. It is invalid to set precision or scale if type ≠ "NUMERIC" and ≠ "BIGNUMERIC". If precision and scale are not specified, no value range constraint is imposed on this field insofar as values are permitted by the type. Values of this NUMERIC or BIGNUMERIC field must be in this range when: - Precision (P) and scale (S) are specified: [-10P-S + 10-S, 10P-S - 10-S] - Precision (P) is specified but not scale (and thus scale is interpreted to be equal to zero): [-10P + 1, 10P - 1]. Acceptable values for precision and scale if both are specified: - If type = "NUMERIC": 1 ≤ precision - scale ≤ 29 and 0 ≤ scale ≤ 9. - If type = "BIGNUMERIC": 1 ≤ precision - scale ≤ 38 and 0 ≤ scale ≤ 38. Acceptable values for precision if only precision is specified but not scale (and thus scale is interpreted to be equal to zero): - If type = "NUMERIC": 1 ≤ precision ≤ 29. - If type = "BIGNUMERIC": 1 ≤ precision ≤ 38. If scale is specified but not precision, then it is invalid.
    precision: Option[Long] = None,
    // Optional. A SQL expression to specify the default value for this field. It can only be set for top level fields (columns). You can use struct or array expression to specify default value for the entire struct or array. The valid SQL expressions are: - Literals for all data types, including STRUCT and ARRAY. - Following functions: - CURRENT_TIMESTAMP - CURRENT_TIME - CURRENT_DATE - CURRENT_DATETIME - GENERATE_UUID - RAND - SESSION_USER - ST_GEOGPOINT - Struct or array composed with the above allowed functions, for example, [CURRENT_DATE(), DATE '2020-01-01']
    defaultValueExpression: Option[String] = None,
    // Optional. The subtype of the RANGE, if the type of this field is RANGE. If the type is RANGE, this field is required. Possible values for the field element type of a RANGE include: - DATE - DATETIME - TIMESTAMP
    rangeElementType: Option[TableFieldSchemaRangeElementType] = None,
    policyTags: Option[TableFieldSchemaPolicyTags] = None,
    // [Optional] The field description. The maximum length is 1,024 characters.
    description: Option[String] = None,
    // [Optional] See documentation for precision.
    scale: Option[Long] = None,
    // [Optional] Describes the nested schema fields if the type property is set to RECORD.
    fields: Option[List[TableFieldSchema]] = None,
    // [Optional] The categories attached to this field, used for field-level access control.
    categories: Option[TableFieldSchemaCategories] = None,
    // [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default value is NULLABLE.
    mode: Option[String] = None,
    // [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as INTEGER), FLOAT, FLOAT64 (same as FLOAT), NUMERIC, BIGNUMERIC, BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE, TIME, DATETIME, INTERVAL, RECORD (where RECORD indicates that the field contains a nested schema) or STRUCT (same as RECORD).
    `type`: String,
    // Optional. Rounding Mode specification of the field. It only can be set on NUMERIC or BIGNUMERIC type fields.
    roundingMode: Option[String] = None,
    // [Optional] Maximum length of values of this field for STRINGS or BYTES. If max_length is not specified, no maximum length constraint is imposed on this field. If type = "STRING", then max_length represents the maximum UTF-8 length of strings in this field. If type = "BYTES", then max_length represents the maximum number of bytes in this field. It is invalid to set this field if type ≠ "STRING" and ≠ "BYTES".
    maxLength: Option[Long] = None,
    // Optional. Collation specification of the field. It only can be set on string type field.
    collation: Option[String] = None,
)
object TableFieldSchema {
  implicit val encoder: Encoder[TableFieldSchema] = Encoder.instance { x =>
    Json.obj(
      "name" := x.name,
      "precision" := x.precision,
      "defaultValueExpression" :=
        x.defaultValueExpression,
      "rangeElementType" := x.rangeElementType,
      "policyTags" := x.policyTags,
      "description" := x.description,
      "scale" := x.scale,
      "fields" := x.fields,
      "categories" := x.categories,
      "mode" := x.mode,
      "type" := x.`type`,
      "roundingMode" := x.roundingMode,
      "maxLength" :=
        x.maxLength,
      "collation" := x.collation,
    )
  }
  implicit val decoder: Decoder[TableFieldSchema] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("name")
      v1 <- c.get[Option[Long]]("precision")
      v2 <- c.get[Option[String]]("defaultValueExpression")
      v3 <- c.get[Option[TableFieldSchemaRangeElementType]]("rangeElementType")
      v4 <- c.get[Option[TableFieldSchemaPolicyTags]]("policyTags")
      v5 <- c.get[Option[String]]("description")
      v6 <- c.get[Option[Long]]("scale")
      v7 <- c.get[Option[List[TableFieldSchema]]]("fields")
      v8 <- c.get[Option[TableFieldSchemaCategories]]("categories")
      v9 <- c.get[Option[String]]("mode")
      v10 <- c.get[String]("type")
      v11 <- c.get[Option[String]]("roundingMode")
      v12 <- c.get[Option[Long]]("maxLength")
      v13 <- c.get[Option[String]]("collation")
    } yield TableFieldSchema(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12, v13)
  }
}
