package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableDataList( // A hash of this page of results.
    etag: Option[String] =
      None, // A token used for paging results. Providing this token instead of the startIndex parameter can help you retrieve stable results when an underlying table is changing.
    pageToken: Option[String] = None, // The total number of rows in the complete table.
    totalRows: Option[Long] = None, // The resource type of the response.
    kind: Option[String] = None, // Rows of results.
    rows: Option[List[TableRow]] = None,
)
object TableDataList {
  implicit val encoder: Encoder[TableDataList] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "pageToken" := x.pageToken,
      "totalRows" := x.totalRows,
      "kind" := x.kind,
      "rows" := x.rows,
    )
  }
  implicit val decoder: Decoder[TableDataList] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[String]]("pageToken")
      v2 <- c.get[Option[Long]]("totalRows")
      v3 <- c.get[Option[String]]("kind")
      v4 <- c.get[Option[List[TableRow]]]("rows")
    } yield TableDataList(v0, v1, v2, v3, v4)
  }
}
