package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableDataInsertAllResponseInsertError(
    // Error information for the row indicated by the index property.
    errors: Option[List[ErrorProto]] = None,
    // The index of the row that error applies to.
    index: Option[Long] = None,
)
object TableDataInsertAllResponseInsertError {
  implicit val encoder: Encoder[
    TableDataInsertAllResponseInsertError
  ] = Encoder.instance(x => Json.obj("errors" := x.errors, "index" := x.index))
  implicit val decoder: Decoder[
    TableDataInsertAllResponseInsertError
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[ErrorProto]]]("errors")
      v1 <- c.get[Option[Long]]("index")
    } yield TableDataInsertAllResponseInsertError(v0, v1)
  }
}
