package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableDataInsertAllResponse(
    // An array of errors for rows that were not inserted.
    insertErrors: Option[List[TableDataInsertAllResponseInsertError]] = None,
    // The resource type of the response.
    kind: Option[String] = None,
)
object TableDataInsertAllResponse {
  implicit val encoder: Encoder[
    TableDataInsertAllResponse
  ] = Encoder.instance { x =>
    Json.obj("insertErrors" := x.insertErrors, "kind" := x.kind)
  }
  implicit val decoder: Decoder[
    TableDataInsertAllResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[TableDataInsertAllResponseInsertError]]]("insertErrors")
      v1 <- c.get[Option[String]]("kind")
    } yield TableDataInsertAllResponse(v0, v1)
  }
}
