package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableDataInsertAllRequestRow(
    // [Optional] A unique ID for each row. BigQuery uses this property to detect duplicate insertion requests on a best-effort basis.
    insertId: Option[String] = None,
    // [Required] A JSON object that contains a row of data. The object's properties and values must match the destination table's schema.
    json: JsonObject,
)
object TableDataInsertAllRequestRow {
  implicit val encoder: Encoder[
    TableDataInsertAllRequestRow
  ] = Encoder.instance { x =>
    Json.obj("insertId" := x.insertId, "json" := x.json)
  }
  implicit val decoder: Decoder[
    TableDataInsertAllRequestRow
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("insertId")
      v1 <- c.get[JsonObject]("json")
    } yield TableDataInsertAllRequestRow(v0, v1)
  }
}
