package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableDataInsertAllRequest(
    // [Optional] Accept rows that contain values that do not match the schema. The unknown values are ignored. Default is false, which treats unknown values as errors.
    ignoreUnknownValues: Option[Boolean] = None,
    // [Optional] Insert all valid rows of a request, even if invalid rows exist. The default value is false, which causes the entire request to fail if any invalid rows exist.
    skipInvalidRows: Option[Boolean] = None,
    // If specified, treats the destination table as a base template, and inserts the rows into an instance table named "{destination}{templateSuffix}". BigQuery will manage creation of the instance table, using the schema of the base template table. See https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables for considerations when working with templates tables.
    templateSuffix: Option[String] = None, // The resource type of the response.
    kind: Option[String] = None, // The rows to insert.
    rows: Option[List[TableDataInsertAllRequestRow]] = None,
)
object TableDataInsertAllRequest {
  implicit val encoder: Encoder[
    TableDataInsertAllRequest
  ] = Encoder.instance { x =>
    Json.obj(
      "ignoreUnknownValues" := x.ignoreUnknownValues,
      "skipInvalidRows" := x.skipInvalidRows,
      "templateSuffix" := x.templateSuffix,
      "kind" := x.kind,
      "rows" := x.rows,
    )
  }
  implicit val decoder: Decoder[
    TableDataInsertAllRequest
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("ignoreUnknownValues")
      v1 <- c.get[Option[Boolean]]("skipInvalidRows")
      v2 <- c.get[Option[String]]("templateSuffix")
      v3 <- c.get[Option[String]]("kind")
      v4 <- c.get[Option[List[TableDataInsertAllRequestRow]]]("rows")
    } yield TableDataInsertAllRequest(v0, v1, v2, v3, v4)
  }
}
