package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableConstraintsForeignKeyReferencedTable(
    datasetId: Option[String] = None,
    projectId: Option[String] = None,
    tableId: Option[String] = None,
)
object TableConstraintsForeignKeyReferencedTable {
  implicit val encoder: Encoder[
    TableConstraintsForeignKeyReferencedTable
  ] = Encoder.instance { x =>
    Json.obj(
      "datasetId" := x.datasetId,
      "projectId" := x.projectId,
      "tableId" := x.tableId,
    )
  }
  implicit val decoder: Decoder[
    TableConstraintsForeignKeyReferencedTable
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("datasetId")
      v1 <- c.get[Option[String]]("projectId")
      v2 <- c.get[Option[String]]("tableId")
    } yield TableConstraintsForeignKeyReferencedTable(v0, v1, v2)
  }
}
