package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableConstraintsForeignKeyColumnReference(
    referencedColumn: Option[String] = None,
    referencingColumn: Option[String] = None,
)
object TableConstraintsForeignKeyColumnReference {
  implicit val encoder: Encoder[
    TableConstraintsForeignKeyColumnReference
  ] = Encoder.instance { x =>
    Json.obj(
      "referencedColumn" := x.referencedColumn,
      "referencingColumn" := x.referencingColumn,
    )
  }
  implicit val decoder: Decoder[
    TableConstraintsForeignKeyColumnReference
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("referencedColumn")
      v1 <- c.get[Option[String]]("referencingColumn")
    } yield TableConstraintsForeignKeyColumnReference(v0, v1)
  }
}
