package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableConstraintsForeignKey(
    columnReferences: Option[List[TableConstraintsForeignKeyColumnReference]] = None,
    name: Option[String] = None,
    referencedTable: Option[
      TableConstraintsForeignKeyReferencedTable
    ] = None,
)
object TableConstraintsForeignKey {
  implicit val encoder: Encoder[
    TableConstraintsForeignKey
  ] = Encoder.instance { x =>
    Json.obj(
      "columnReferences" := x.columnReferences,
      "name" := x.name,
      "referencedTable" := x.referencedTable,
    )
  }
  implicit val decoder: Decoder[
    TableConstraintsForeignKey
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[TableConstraintsForeignKeyColumnReference]]]("columnReferences")
      v1 <- c.get[Option[String]]("name")
      v2 <- c.get[Option[TableConstraintsForeignKeyReferencedTable]]("referencedTable")
    } yield TableConstraintsForeignKey(v0, v1, v2)
  }
}
