package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableConstraints( // [Optional] The foreign keys of the tables.
    foreignKeys: Option[List[TableConstraintsForeignKey]] =
      None, // [Optional] The primary key of the table.
    primaryKey: Option[TableConstraintsPrimaryKey] = None,
)
object TableConstraints {
  implicit val encoder: Encoder[TableConstraints] = Encoder.instance { x =>
    Json.obj("foreignKeys" := x.foreignKeys, "primaryKey" := x.primaryKey)
  }
  implicit val decoder: Decoder[TableConstraints] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[TableConstraintsForeignKey]]]("foreignKeys")
      v1 <- c.get[Option[TableConstraintsPrimaryKey]]("primaryKey")
    } yield TableConstraints(v0, v1)
  }
}
