package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class TableCell(v: Option[Json] = None)
object TableCell {
  implicit val encoder: Encoder[TableCell] = Encoder.instance { x =>
    Json.obj("v" := x.v)
  }
  implicit val decoder: Decoder[TableCell] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Json]]("v")
    } yield TableCell(v0)
  }
}
