package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scodec.bits.ByteVector
import scala.concurrent.duration.FiniteDuration

final case class Table(
    // Custom encryption configuration (e.g., Cloud KMS keys).
    encryptionConfiguration: Option[EncryptionConfiguration] = None,
    // [Output-only] A hash of the table metadata. Used to ensure there were no concurrent modifications to the resource when attempting an update. Not guaranteed to change when the table contents or the fields numRows, numBytes, numLongTermBytes or lastModifiedTime change.
    etag: Option[String] = None,
    // [Output-only] The time when this table was last modified, in milliseconds since the epoch.
    lastModifiedTime: Option[BigInt] = None,
    // [Required] Reference describing the ID of this table.
    tableReference: TableReference,
    // [Output-only] [TrustedTester] The physical size of this table in bytes, excluding any data in the streaming buffer. This includes compression and storage used for time travel.
    numPhysicalBytes: Option[Long] = None,
    // [Optional] The time when this table expires, in milliseconds since the epoch. If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to set a default expirationTime on newly created tables.
    expirationTime: Option[FiniteDuration] = None,
    // [Output-only] The geographic location where the table resides. This value is inherited from the dataset.
    location: Option[String] = None,
    // [Optional] Describes the data format, location, and other properties of a table stored outside of BigQuery. By defining these properties, the data source can then be queried as if it were a standard BigQuery table.
    externalDataConfiguration: Option[ExternalDataConfiguration] = None,
    // [Output-only, Beta] Present iff this table represents a ML model. Describes the training information for the model, and it is required to run 'PREDICT' queries.
    model: Option[ModelDefinition] = None,
    // [Optional] A user-friendly description of this table.
    description: Option[String] = None,
    // [Optional] The table constraints on the table.
    tableConstraints: Option[TableConstraints] = None,
    // [Output-only] Number of physical bytes used by time travel storage (deleted or changed data). This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
    numTimeTravelPhysicalBytes: Option[Long] = None,
    // [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
    requirePartitionFilter: Option[Boolean] = None,
    // [Optional] A descriptive name for this table.
    friendlyName: Option[String] = None,
    // [Output-only] A URL that can be used to access this resource again.
    selfLink: Option[String] = None,
    // [Optional] The tags associated with this table. Tag keys are globally unique. See additional information on [tags](https://cloud.google.com/iam/docs/tags-access-control#definitions). An object containing a list of "key": value pairs. The key is the namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is parent id. The value is the friendly short name of the tag value, e.g. "production".
    resourceTags: Option[Map[String, String]] = None,
    // [Output-only] Number of logical bytes that are more than 90 days old.
    numLongTermLogicalBytes: Option[Long] = None,
    // [Output-only] Number of logical bytes that are less than 90 days old.
    numActiveLogicalBytes: Option[Long] = None,
    // [Output-only] Number of physical bytes less than 90 days old. This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
    numActivePhysicalBytes: Option[Long] = None,
    // [Output-only] An opaque ID uniquely identifying the table.
    id: Option[String] = None,
    // [Output-only] Total number of logical bytes in the table or materialized view.
    numTotalLogicalBytes: Option[Long] = None,
    // [Optional] Describes the schema of this table.
    schema: Option[TableSchema] = None,
    // Time-based partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
    timePartitioning: Option[TimePartitioning] = None,
    // The labels associated with this table. You can use these to organize and group your tables. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
    labels: Option[Map[String, String]] = None,
    // [Output-only] Number of physical bytes more than 90 days old. This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
    numLongTermPhysicalBytes: Option[Long] = None,
    // [Output-only] The default rounding mode of the table.
    defaultRoundingMode: Option[String] = None,
    // [Output-only] The number of bytes in the table that are considered "long-term storage".
    numLongTermBytes: Option[Long] = None, // [Output-only] Snapshot definition.
    snapshotDefinition: Option[SnapshotDefinition] = None,
    // [Output-only] The physical size of this table in bytes. This also includes storage used for time travel. This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
    numTotalPhysicalBytes: Option[Long] = None,
    // [Output-only] The default collation of the table.
    defaultCollation: Option[String] = None,
    // [Output-only] The type of the resource.
    kind: Option[String] = None,
    // [Optional] Max staleness of data that could be returned when table or materialized view is queried (formatted as Google SQL Interval type).
    maxStaleness: Option[ByteVector] = None,
    // [Output-only] Describes the table type. The following values are supported: TABLE: A normal BigQuery table. VIEW: A virtual table defined by a SQL query. SNAPSHOT: An immutable, read-only table that is a copy of another table. [TrustedTester] MATERIALIZED_VIEW: SQL query whose result is persisted. EXTERNAL: A table that references data stored in an external storage system, such as Google Cloud Storage. The default value is TABLE.
    `type`: Option[String] = None, // [Output-only] Clone definition.
    cloneDefinition: Option[CloneDefinition] = None,
    // [Output-only] The size of this table in bytes, excluding any data in the streaming buffer.
    numBytes: Option[Long] = None,
    // [Optional] Specifies the configuration of a BigLake managed table.
    biglakeConfiguration: Option[BigLakeConfiguration] = None,
    // [Output-only] Contains information regarding this table's streaming buffer, if one is present. This field will be absent if the table is not being streamed to or if there is no data in the streaming buffer.
    streamingBuffer: Option[Streamingbuffer] = None,
    // [Output-only] The number of partitions present in the table or materialized view. This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
    numPartitions: Option[Long] = None,
    // [Output-only] The number of rows of data in this table, excluding any data in the streaming buffer.
    numRows: Option[BigInt] = None, // [Optional] Materialized view definition.
    materializedView: Option[MaterializedViewDefinition] = None,
    // [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
    rangePartitioning: Option[RangePartitioning] = None,
    // [Output-only] The time when this table was created, in milliseconds since the epoch.
    creationTime: Option[FiniteDuration] = None,
    // [Optional] The view definition.
    view: Option[ViewDefinition] = None,
    // [Beta] Clustering specification for the table. Must be specified with partitioning, data in the table will be first partitioned and subsequently clustered.
    clustering: Option[Clustering] = None,
)
object Table {
  implicit val encoder: Encoder[Table] = Encoder.instance { x =>
    Json.obj(
      "encryptionConfiguration" := x.encryptionConfiguration,
      "etag" := x.etag,
      "lastModifiedTime" := x.lastModifiedTime,
      "tableReference" := x.tableReference,
      "numPhysicalBytes" := x.numPhysicalBytes,
      "expirationTime"
        := x.expirationTime,
      "location" := x.location,
      "externalDataConfiguration"
        := x.externalDataConfiguration,
      "model" := x.model,
      "description" := x.description,
      "tableConstraints" := x.tableConstraints,
      "numTimeTravelPhysicalBytes" := x.numTimeTravelPhysicalBytes,
      "requirePartitionFilter" := x.requirePartitionFilter,
      "friendlyName" := x.friendlyName,
      "selfLink" := x.selfLink,
      "resourceTags" := x.resourceTags,
      "numLongTermLogicalBytes" := x.numLongTermLogicalBytes,
      "numActiveLogicalBytes" := x.numActiveLogicalBytes,
      "numActivePhysicalBytes" := x.numActivePhysicalBytes,
      "id" := x.id,
      "numTotalLogicalBytes" := x.numTotalLogicalBytes,
      "schema" := x.schema,
      "timePartitioning" := x.timePartitioning,
      "labels" := x.labels,
      "numLongTermPhysicalBytes" := x.numLongTermPhysicalBytes,
      "defaultRoundingMode" := x.defaultRoundingMode,
      "numLongTermBytes" := x.numLongTermBytes,
      "snapshotDefinition" := x.snapshotDefinition,
      "numTotalPhysicalBytes" := x.numTotalPhysicalBytes,
      "defaultCollation" :=
        x.defaultCollation,
      "kind" := x.kind,
      "maxStaleness" := x.maxStaleness,
      "type" := x.`type`,
      "cloneDefinition" := x.cloneDefinition,
      "numBytes" :=
        x.numBytes,
      "biglakeConfiguration" := x.biglakeConfiguration,
      "streamingBuffer" := x.streamingBuffer,
      "numPartitions" := x.numPartitions,
      "numRows" := x.numRows,
      "materializedView" := x.materializedView,
      "rangePartitioning" := x.rangePartitioning,
      "creationTime" := x.creationTime,
      "view" := x.view,
      "clustering" := x.clustering,
    )
  }
  implicit val decoder: Decoder[Table] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[EncryptionConfiguration]]("encryptionConfiguration")
      v1 <- c.get[Option[String]]("etag")
      v2 <- c.get[Option[BigInt]]("lastModifiedTime")
      v3 <- c.get[TableReference]("tableReference")
      v4 <- c.get[Option[Long]]("numPhysicalBytes")
      v5 <- c.get[Option[FiniteDuration]]("expirationTime")
      v6 <- c.get[Option[String]]("location")
      v7 <- c.get[Option[ExternalDataConfiguration]]("externalDataConfiguration")
      v8 <- c.get[Option[ModelDefinition]]("model")
      v9 <- c.get[Option[String]]("description")
      v10 <- c.get[Option[TableConstraints]]("tableConstraints")
      v11 <- c.get[Option[Long]]("numTimeTravelPhysicalBytes")
      v12 <- c.get[Option[Boolean]]("requirePartitionFilter")
      v13 <- c.get[Option[String]]("friendlyName")
      v14 <- c.get[Option[String]]("selfLink")
      v15 <- c.get[Option[Map[String, String]]]("resourceTags")
      v16 <- c.get[Option[Long]]("numLongTermLogicalBytes")
      v17 <- c.get[Option[Long]]("numActiveLogicalBytes")
      v18 <- c.get[Option[Long]]("numActivePhysicalBytes")
      v19 <- c.get[Option[String]]("id")
      v20 <- c.get[Option[Long]]("numTotalLogicalBytes")
      v21 <- c.get[Option[TableSchema]]("schema")
      v22 <- c.get[Option[TimePartitioning]]("timePartitioning")
      v23 <- c.get[Option[Map[String, String]]]("labels")
      v24 <- c.get[Option[Long]]("numLongTermPhysicalBytes")
      v25 <- c.get[Option[String]]("defaultRoundingMode")
      v26 <- c.get[Option[Long]]("numLongTermBytes")
      v27 <- c.get[Option[SnapshotDefinition]]("snapshotDefinition")
      v28 <- c.get[Option[Long]]("numTotalPhysicalBytes")
      v29 <- c.get[Option[String]]("defaultCollation")
      v30 <- c.get[Option[String]]("kind")
      v31 <- c.get[Option[ByteVector]]("maxStaleness")
      v32 <- c.get[Option[String]]("type")
      v33 <- c.get[Option[CloneDefinition]]("cloneDefinition")
      v34 <- c.get[Option[Long]]("numBytes")
      v35 <- c.get[Option[BigLakeConfiguration]]("biglakeConfiguration")
      v36 <- c.get[Option[Streamingbuffer]]("streamingBuffer")
      v37 <- c.get[Option[Long]]("numPartitions")
      v38 <- c.get[Option[BigInt]]("numRows")
      v39 <- c.get[Option[MaterializedViewDefinition]]("materializedView")
      v40 <- c.get[Option[RangePartitioning]]("rangePartitioning")
      v41 <- c.get[Option[FiniteDuration]]("creationTime")
      v42 <- c.get[Option[ViewDefinition]]("view")
      v43 <- c.get[Option[Clustering]]("clustering")
    } yield Table(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
      v22,
      v23,
      v24,
      v25,
      v26,
      v27,
      v28,
      v29,
      v30,
      v31,
      v32,
      v33,
      v34,
      v35,
      v36,
      v37,
      v38,
      v39,
      v40,
      v41,
      v42,
      v43,
    )
  }
}
