package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class StringHparamSearchSpace(
    // Canididates for the string or enum parameter in lower case.
    candidates: Option[List[String]] = None
)
object StringHparamSearchSpace {
  implicit val encoder: Encoder[
    StringHparamSearchSpace
  ] = Encoder.instance(x => Json.obj("candidates" := x.candidates))
  implicit val decoder: Decoder[
    StringHparamSearchSpace
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("candidates")
    } yield StringHparamSearchSpace(v0)
  }
}
