package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Streamingbuffer(
    // [Output-only] A lower-bound estimate of the number of bytes currently in the streaming buffer.
    estimatedBytes: Option[BigInt] = None,
    // [Output-only] A lower-bound estimate of the number of rows currently in the streaming buffer.
    estimatedRows: Option[BigInt] = None,
    // [Output-only] Contains the timestamp of the oldest entry in the streaming buffer, in milliseconds since the epoch, if the streaming buffer is available.
    oldestEntryTime: Option[BigInt] = None,
)
object Streamingbuffer {
  implicit val encoder: Encoder[Streamingbuffer] = Encoder.instance { x =>
    Json.obj(
      "estimatedBytes" := x.estimatedBytes,
      "estimatedRows" := x.estimatedRows,
      "oldestEntryTime" := x.oldestEntryTime,
    )
  }
  implicit val decoder: Decoder[Streamingbuffer] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[BigInt]]("estimatedBytes")
      v1 <- c.get[Option[BigInt]]("estimatedRows")
      v2 <- c.get[Option[BigInt]]("oldestEntryTime")
    } yield Streamingbuffer(v0, v1, v2)
  }
}
