package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class StandardSqlTableType( // The columns in this table type
    columns: Option[List[StandardSqlField]] = None
)
object StandardSqlTableType {
  implicit val encoder: Encoder[StandardSqlTableType] = Encoder.instance { x =>
    Json.obj("columns" := x.columns)
  }
  implicit val decoder: Decoder[StandardSqlTableType] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[StandardSqlField]]]("columns")
    } yield StandardSqlTableType(v0)

  }
}
