package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class StandardSqlStructType( // Fields within the struct.
    fields: Option[List[StandardSqlField]] = None
)
object StandardSqlStructType {
  implicit val encoder: Encoder[StandardSqlStructType] = Encoder.instance { x =>
    Json.obj("fields" := x.fields)
  }
  implicit val decoder: Decoder[StandardSqlStructType] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[StandardSqlField]]]("fields")
    } yield StandardSqlStructType(v0)

  }
}
