package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class StandardSqlField(
    // Optional. The name of this field. Can be absent for struct fields.
    name: Option[String] = None,
    // Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION statement can omit the return type; in this case the output parameter does not have this "type" field).
    `type`: Option[StandardSqlDataType] = None,
)
object StandardSqlField {
  implicit val encoder: Encoder[StandardSqlField] = Encoder.instance { x =>
    Json.obj("name" := x.name, "type" := x.`type`)
  }
  implicit val decoder: Decoder[StandardSqlField] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("name")
      v1 <- c.get[Option[StandardSqlDataType]]("type")
    } yield StandardSqlField(v0, v1)
  }
}
