package googleapis.bigquery

import io.circe._

sealed abstract class StandardSqlDataTypeTypeKind(val value: String)
    extends Product
    with Serializable
object StandardSqlDataTypeTypeKind {
  // Invalid type.
  case object TYPE_KIND_UNSPECIFIED extends StandardSqlDataTypeTypeKind("TYPE_KIND_UNSPECIFIED")
  // Encoded as a string in decimal format.
  case object INT64 extends StandardSqlDataTypeTypeKind("INT64")
  // Encoded as a boolean "false" or "true".
  case object BOOL extends StandardSqlDataTypeTypeKind("BOOL")
  // Encoded as a number, or string "NaN", "Infinity" or "-Infinity".
  case object FLOAT64 extends StandardSqlDataTypeTypeKind("FLOAT64")
  // Encoded as a string value.
  case object STRING extends StandardSqlDataTypeTypeKind("STRING")
  // Encoded as a base64 string per RFC 4648, section 4.
  case object BYTES extends StandardSqlDataTypeTypeKind("BYTES")
  // Encoded as an RFC 3339 timestamp with mandatory "Z" time zone string: 1985-04-12T23:20:50.52Z
  case object TIMESTAMP extends StandardSqlDataTypeTypeKind("TIMESTAMP")
  // Encoded as RFC 3339 full-date format string: 1985-04-12
  case object DATE extends StandardSqlDataTypeTypeKind("DATE")
  // Encoded as RFC 3339 partial-time format string: 23:20:50.52
  case object TIME extends StandardSqlDataTypeTypeKind("TIME")
  // Encoded as RFC 3339 full-date "T" partial-time: 1985-04-12T23:20:50.52
  case object DATETIME extends StandardSqlDataTypeTypeKind("DATETIME")
  // Encoded as fully qualified 3 part: 0-5 15 2:30:45.6
  case object INTERVAL extends StandardSqlDataTypeTypeKind("INTERVAL")
  // Encoded as WKT
  case object GEOGRAPHY extends StandardSqlDataTypeTypeKind("GEOGRAPHY")
  // Encoded as a decimal string.
  case object NUMERIC extends StandardSqlDataTypeTypeKind("NUMERIC")
  // Encoded as a decimal string.
  case object BIGNUMERIC extends StandardSqlDataTypeTypeKind("BIGNUMERIC")
  // Encoded as a string.
  case object JSON extends StandardSqlDataTypeTypeKind("JSON")
  // Encoded as a list with types matching Type.array_type.
  case object ARRAY extends StandardSqlDataTypeTypeKind("ARRAY")
  // Encoded as a list with fields of type Type.struct_type[i]. List is used because a JSON object cannot have duplicate field names.
  case object STRUCT extends StandardSqlDataTypeTypeKind("STRUCT")
  // Encoded as a pair with types matching range_element_type. Pairs must begin with "[", end with ")", and be separated by ", ".
  case object RANGE extends StandardSqlDataTypeTypeKind("RANGE")
  val values = List(
    TYPE_KIND_UNSPECIFIED,
    INT64,
    BOOL,
    FLOAT64,
    STRING,
    BYTES,
    TIMESTAMP,
    DATE,
    TIME,
    DATETIME,
    INTERVAL,
    GEOGRAPHY,
    NUMERIC,
    BIGNUMERIC,
    JSON,
    ARRAY,
    STRUCT,
    RANGE,
  )
  def fromString(input: String): Either[String, StandardSqlDataTypeTypeKind] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for StandardSqlDataTypeTypeKind")
  implicit val decoder: Decoder[StandardSqlDataTypeTypeKind] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[StandardSqlDataTypeTypeKind] = Encoder[String].contramap(_.value)
}
