package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class StandardSqlDataType(
    // The type of the array's elements, if type_kind = "ARRAY".
    arrayElementType: Option[StandardSqlDataType] = None,
    // The type of the range's elements, if type_kind = "RANGE".
    rangeElementType: Option[StandardSqlDataType] = None,
    // The fields of this struct, in order, if type_kind = "STRUCT".
    structType: Option[StandardSqlStructType] = None,
    // Required. The top level type of this field. Can be any GoogleSQL data type (e.g., "INT64", "DATE", "ARRAY").
    typeKind: Option[StandardSqlDataTypeTypeKind] = None,
)
object StandardSqlDataType {
  implicit val encoder: Encoder[StandardSqlDataType] = Encoder.instance { x =>
    Json.obj(
      "arrayElementType" := x.arrayElementType,
      "rangeElementType" := x.rangeElementType,
      "structType" := x.structType,
      "typeKind" := x.typeKind,
    )
  }
  implicit val decoder: Decoder[StandardSqlDataType] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[StandardSqlDataType]]("arrayElementType")
      v1 <- c.get[Option[StandardSqlDataType]]("rangeElementType")
      v2 <- c.get[Option[StandardSqlStructType]]("structType")
      v3 <- c.get[Option[StandardSqlDataTypeTypeKind]]("typeKind")
    } yield StandardSqlDataType(v0, v1, v2, v3)

  }
}
