package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class SparkStatistics(
    // [Output-only] Endpoints generated for the Spark job.
    endpoints: Option[Map[String, String]] = None,
    // [Output-only] Logging info is used to generate a link to Cloud Logging.
    loggingInfo: Option[SparkLoggingInfo] = None,
    // [Output-only] Spark job id if a Spark job is created successfully.
    sparkJobId: Option[String] = None,
    // [Output-only] Location where the Spark job is executed.
    sparkJobLocation: Option[String] = None,
)
object SparkStatistics {
  implicit val encoder: Encoder[SparkStatistics] = Encoder.instance { x =>
    Json.obj(
      "endpoints" := x.endpoints,
      "loggingInfo" := x.loggingInfo,
      "sparkJobId"
        := x.sparkJobId,
      "sparkJobLocation" := x.sparkJobLocation,
    )
  }
  implicit val decoder: Decoder[SparkStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Map[String, String]]]("endpoints")
      v1 <- c.get[Option[SparkLoggingInfo]]("loggingInfo")
      v2 <- c.get[Option[String]]("sparkJobId")
      v3 <- c.get[Option[String]]("sparkJobLocation")
    } yield SparkStatistics(v0, v1, v2, v3)
  }
}
