package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class SparkLoggingInfo( // [Output-only] Project ID used for logging
    projectId: Option[String] = None, // [Output-only] Resource type used for logging
    resourceType: Option[String] = None,
)
object SparkLoggingInfo {
  implicit val encoder: Encoder[SparkLoggingInfo] = Encoder.instance { x =>
    Json.obj("projectId" := x.projectId, "resourceType" := x.resourceType)
  }
  implicit val decoder: Decoder[SparkLoggingInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("projectId")
      v1 <- c.get[Option[String]]("resourceType")
    } yield SparkLoggingInfo(v0, v1)
  }
}
