package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class SnapshotDefinition(
    // [Required] Reference describing the ID of the table that was snapshot.
    baseTableReference: TableReference,
    // [Required] The time at which the base table was snapshot. This value is reported in the JSON response using RFC3339 format.
    snapshotTime: String,
)
object SnapshotDefinition {
  implicit val encoder: Encoder[SnapshotDefinition] = Encoder.instance { x =>
    Json.obj(
      "baseTableReference" := x.baseTableReference,
      "snapshotTime" := x.snapshotTime,
    )
  }
  implicit val decoder: Decoder[SnapshotDefinition] = Decoder.instance { c =>
    for {
      v0 <- c.get[TableReference]("baseTableReference")
      v1 <- c.get[String]("snapshotTime")
    } yield SnapshotDefinition(v0, v1)

  }
}
