package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class SetIamPolicyRequest(
    // REQUIRED: The complete policy to be applied to the `resource`. The size of the policy is limited to a few 10s of KB. An empty policy is a valid policy but certain Google Cloud services (such as Projects) might reject them.
    policy: Option[Policy] = None,
    // OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only the fields in the mask will be modified. If no mask is provided, the following default mask is used: `paths: "bindings, etag"`
    updateMask: Option[String] = None,
)
object SetIamPolicyRequest {
  implicit val encoder: Encoder[SetIamPolicyRequest] = Encoder.instance { x =>
    Json.obj("policy" := x.policy, "updateMask" := x.updateMask)
  }
  implicit val decoder: Decoder[SetIamPolicyRequest] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Policy]]("policy")
      v1 <- c.get[Option[String]]("updateMask")
    } yield SetIamPolicyRequest(v0, v1)

  }
}
