package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class SessionInfo( // [Output-only] // [Preview] Id of the session.
    sessionId: Option[String] = None
)
object SessionInfo {
  implicit val encoder: Encoder[SessionInfo] = Encoder.instance { x =>
    Json.obj("sessionId" := x.sessionId)
  }
  implicit val decoder: Decoder[SessionInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("sessionId")
    } yield SessionInfo(v0)
  }
}
