package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class SearchStatistics(
    // When index_usage_mode is UNUSED or PARTIALLY_USED, this field explains why index was not used in all or part of the search query. If index_usage_mode is FULLLY_USED, this field is not populated.
    indexUnusedReasons: Option[List[IndexUnusedReason]] = None,
    // Specifies index usage mode for the query.
    indexUsageMode: Option[String] = None,
)
object SearchStatistics {
  implicit val encoder: Encoder[SearchStatistics] = Encoder.instance { x =>
    Json.obj(
      "indexUnusedReasons" := x.indexUnusedReasons,
      "indexUsageMode" := x.indexUsageMode,
    )
  }
  implicit val decoder: Decoder[SearchStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[IndexUnusedReason]]]("indexUnusedReasons")
      v1 <- c.get[Option[String]]("indexUsageMode")
    } yield SearchStatistics(v0, v1)
  }
}
