package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ScriptStatistics(
    // [Output-only] Whether this child job was a statement or expression.
    evaluationKind: Option[String] = None,
    // Stack trace showing the line/column/procedure name of each frame on the stack at the point where the current evaluation happened. The leaf frame is first, the primary script is last. Never empty.
    stackFrames: Option[List[ScriptStackFrame]] = None,
)
object ScriptStatistics {
  implicit val encoder: Encoder[ScriptStatistics] = Encoder.instance { x =>
    Json.obj(
      "evaluationKind" := x.evaluationKind,
      "stackFrames" := x.stackFrames,
    )
  }
  implicit val decoder: Decoder[ScriptStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("evaluationKind")
      v1 <- c.get[Option[List[ScriptStackFrame]]]("stackFrames")
    } yield ScriptStatistics(v0, v1)
  }
}
