package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ScriptStackFrame( // [Output-only] One-based start line.
    startLine: Option[Int] = None, // [Output-only] One-based end column.
    endColumn: Option[Int] =
      None, // [Output-only] Name of the active procedure, empty if in a top-level script.
    procedureId: Option[String] = None, // [Output-only] Text of the current statement/expression.
    text: Option[String] = None, // [Output-only] One-based end line.
    endLine: Option[Int] = None, // [Output-only] One-based start column.
    startColumn: Option[Int] = None,
)
object ScriptStackFrame {
  implicit val encoder: Encoder[ScriptStackFrame] = Encoder.instance { x =>
    Json.obj(
      "startLine" := x.startLine,
      "endColumn" := x.endColumn,
      "procedureId" := x.procedureId,
      "text" := x.text,
      "endLine" := x.endLine,
      "startColumn" := x.startColumn,
    )
  }
  implicit val decoder: Decoder[ScriptStackFrame] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Int]]("startLine")
      v1 <- c.get[Option[Int]]("endColumn")
      v2 <- c.get[Option[String]]("procedureId")
      v3 <- c.get[Option[String]]("text")
      v4 <- c.get[Option[Int]]("endLine")
      v5 <- c.get[Option[Int]]("startColumn")
    } yield ScriptStackFrame(v0, v1, v2, v3, v4, v5)
  }
}
